	clear all
	close all
	clc
	
	% Compute initial filter
	wcT = 0.05*pi; wsT = 0.1*pi; Amax = 0.2; Amin = 60;
	N = 9; 
	[G, Z, R_ZEROS, P, WsnewT] = CA_POLES_Z(wcT, wsT, Amax, Amin, N);
	[S1num,S1den,S2num,S2den] = SORT_LATTICE_POLES_LP_Z(P);
 	[alfa_odd, alfa_even] = CASCADE_RICHARDS_SECTIONS(S1den,S2den);
	wT = linspace(0, pi,10000);
	[S1, S2] = LATTICE_RICHARDS_H(alfa_odd, alfa_even, wT);
	figure(1)
	H = 0.5*(S2 - S1);
	PLOT_MAG_Z_dB(wT, H, pi, 80, 'H')
 	global wTc wTs dc ds Nodd
	Nodd = length(alfa_odd); % Odd branch
	wTc = linspace(0,wcT,101);	wTs = linspace(wsT,pi,901);
	dc = 0.022762778;	% Passband Amax = -20*log10(1 - dc) = 0.2 dB
	ds = 0.001;			% Stopband Amin = -20*log10(ds) = 60 dB
	%	warning off
	% Optimization part
	Taug = 40.38; 	Phase_error = 0;	% Initial estimates
	x0 = [0 Taug alfa_odd alfa_even];	% Optim. parameters
	% Set lower and upper bounds on parameters
	vlb = 0;	vlb(1:2) = [0 10];		vlb(3:length(x0)) = -0.99999;
	vub = 0;	vub(1:2) = [0.1 50];	vub(3:length(x0)) = 0.99999;
	options = foptions; options(2:3) = 1e-8; options(14) = 1000;
	warning off
	disp(['Optimizing! Wait!'])
	x = fminimax('EX_12_9_fun', x0, options, vlb, vub); % fminimax
	alfa_odd = x(3:length(alfa_odd)+2)';
	alfa_even = x(length(alfa_odd)+3:length(x))';
	Phase_error = x(1);	Taug_average = x(2);
	alfa_odd, alfa_even
	
	figure(2)
	wT = linspace(0, pi,1000);
	[S1, S2] = LATTICE_RICHARDS_H(alfa_odd, alfa_even, wT);
	Att = H_2_ATT(0.5*(S2 - S1));
	subplot('position', [0.08 0.4 0.90 0.5]); 
	PLOT_ATT_Z(wT, Att, pi, 80) 
	[S1, S2] = LATTICE_RICHARDS_H(alfa_odd, alfa_even, wTc);
	Att = H_2_ATT(0.5*(S2 - S1)); 
	axes('position',[0.60 0.52 0.3 0.2]);
	PLOT_ATT_Z_LS(wTc, Att, 0.2)
	figure(3)
	subplot(3,1,1);
	Ph_error = unwrap(angle(S2-S1) + x(2)*wTc);
	PLOT_DELTA_PHASE_Z(wTc, Ph_error, -2*10^-3 , 2*10^-3)	
	
	subplot(3,1,2)
	Taug = LATTICE_RICHARDS_TAUG(alfa_odd, alfa_even, wTc);
	PLOT_TG_Z(wTc, Taug,  40, 41.5)
